/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS;

import java.util.Map;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.modules.IoFileMgrForUser;
import jpcsp.Memory;

public class MemoryVirtualFile
implements IVirtualFile {
    private final TPointer startPtr;
    private final TPointer ptr;
    private final int length;

    public MemoryVirtualFile(int address, int length) {
        Memory mem = Memory.getInstance();
        this.startPtr = new TPointer(mem, address);
        this.ptr = new TPointer(mem, address);
        this.length = length;
    }

    public MemoryVirtualFile(TPointer ptr, int length) {
        this.startPtr = new TPointer(ptr);
        this.ptr = new TPointer(ptr);
        this.length = length;
    }

    @Override
    public int ioClose() {
        this.ptr.setAddress(0);
        return 0;
    }

    private int remainingLength() {
        return this.length - (this.ptr.getAddress() - this.startPtr.getAddress());
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        outputLength = Math.min(outputLength, this.remainingLength());
        outputPointer.memcpy(this.ptr, outputLength);
        this.ptr.add(outputLength);
        return outputLength;
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        outputLength = Math.min(outputLength, this.remainingLength());
        this.ptr.getArray8(0, outputBuffer, outputOffset, outputLength);
        this.ptr.add(outputLength);
        return outputLength;
    }

    @Override
    public int ioWrite(TPointer inputPointer, int inputLength) {
        inputLength = Math.min(inputLength, this.remainingLength());
        inputPointer.memcpy(this.ptr, inputLength);
        this.ptr.add(inputLength);
        return inputLength;
    }

    @Override
    public int ioWrite(byte[] inputBuffer, int inputOffset, int inputLength) {
        inputLength = Math.min(inputLength, this.remainingLength());
        this.ptr.setArray(0, inputBuffer, inputOffset, inputLength);
        this.ptr.add(inputLength);
        return inputLength;
    }

    @Override
    public long ioLseek(long offset) {
        this.ptr.setAddress(this.startPtr.getAddress() + (int)offset);
        return offset;
    }

    @Override
    public int ioIoctl(int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        return -1;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public boolean isSectorBlockMode() {
        return false;
    }

    @Override
    public long getPosition() {
        return this.ptr.getAddress() - this.startPtr.getAddress();
    }

    @Override
    public IVirtualFile duplicate() {
        MemoryVirtualFile vFile = new MemoryVirtualFile(this.startPtr, this.length);
        vFile.ioLseek(this.getPosition());
        return vFile;
    }

    @Override
    public Map<IoFileMgrForUser.IoOperation, IoFileMgrForUser.IoOperationTiming> getTimings() {
        return IoFileMgrForUser.defaultTimings;
    }

    public String toString() {
        return String.format("MemoryVirtualFile %s-%s (length=0x%X)", this.startPtr, new TPointer(this.startPtr, this.length), this.length);
    }
}

